#include <Arduino.h>
#include <EEPROM.h>

#include "Configuration.h"
#include "Keyboard.h"
#include "Display.h"
#include "Transceiver.h"

Keyboard keyboard = Keyboard();
Display display = Display();
Transceiver transceiver = Transceiver();

// 0 single mode
// 1 auto mode
// 2 Transceiver play back
// 3 wait loop till next playback
// 10 menu
int state = 0;

// last pressed key for state 0 and 1
int modeKey = -1;

// delay after playback
// 4 bit value*1000
// 0 - 31000 milliseconds
int autoDelay = 2000;

// counting variable for blinking
int blinkCounter = 0;

// timestamp of last playback start
unsigned long lastAutoThick = NULL;

void setup()
{
    Serial.begin(9600);

    keyboard.init();
    display.init();
    transceiver.init();
    //display.larson();
    
    pinMode(PIN_KEY_PTT, INPUT_PULLUP);

    autoDelay = EEPROM.read(EPP_ADDR)*1000;

}

void enterLeaveMenu()
{

    if( state == 10)
    {

        int tmp = 0;
        if(display.isOn(0))
        {
            tmp |= 8;
        }
        if(display.isOn(1))
        {
            tmp |= 4;
        }
        if(display.isOn(2))
        {
            tmp |= 2;
        }
        if(display.isOn(3))
        {    
            tmp |= 1;
        }

        EEPROM.write(EPP_ADDR,tmp);
        autoDelay = tmp*1000;

        // turning all lights off
        display.off();

        state = 0;
        display.larson1(1);

    }
    else
    {

        display.larson1(1);

        // turning all lights off
        display.off();

        //autoDelay
        int tmp = autoDelay/1000;

        display.on(3, tmp>>0 & 1  );
        display.on(2, tmp>>1 & 1  );
        display.on(1, tmp>>2 & 1  );
        display.on(0, tmp>>3 & 1  );
        
        state = 10;
        
    }
}

void loop()
{

    unsigned long cTime = millis();

    keyboard.main();
    display.main();
    transceiver.main();

    switch(state)
    {
        case 0:
        case 1:
            // normal loop

            if( keyboard.isLongDown(0))
                display.pulse(0);
            if( keyboard.isLongDown(1))
                display.pulse(1);
            if( keyboard.isLongDown(2))
                display.pulse(2 );
            if( keyboard.isLongDown(3))
                display.pulse(3);
            
            if(keyboard.pressed(0,false) == 2)
            {
                enterLeaveMenu();
                break;
            }

            else if(keyboard.pressed(0,false) == 1)
            {
                // start file 0
                //Serial.println("single 0");
                state = 0;
                modeKey = 0;
            }
            else if(keyboard.pressed(1,false) == 1)
            {
                // start file 1
                //Serial.println("single 1");
                state = 0;
                modeKey = 1;
            }
            else if(keyboard.pressed(2,false) == 1)
            {
                // start file 2
                //Serial.println("single 2");
                state = 0;
                modeKey = 2;
            }
            else if(keyboard.pressed(3,false) == 1)
            {
                // start file 3
                //Serial.println("single 3");
                state = 0;
                modeKey = 3;
            }

            else if(keyboard.pressed(0,true) == 1)
            {
                // start file 0
                //Serial.println("auto 0");
                state = 1;
                modeKey = 0;
                lastAutoThick = cTime-autoDelay;
            }
            else if(keyboard.pressed(1,true) == 1)
            {
                // start file 1
                //Serial.println("auto 1");
                state = 1;
                modeKey = 1;
                lastAutoThick = cTime-autoDelay;
            }
            else if(keyboard.pressed(2,true) == 1)
            {
                // start file 2
                //Serial.println("auto 2");
                state = 1;
                modeKey = 2;
                lastAutoThick = cTime-autoDelay;
            }
            else if(keyboard.pressed(3,true) == 1)
            {
                // start file 3
                //Serial.println("auto 3");
                state = 1;
                modeKey = 3;
                lastAutoThick = cTime-autoDelay;
            }

            if (state == 0)
            {
                if(modeKey >= 0)
                {
                    // single mode
                    //Serial.println("single mode: "+ String(modeKey) );
                    transceiver.pulse(modeKey);
                    display.pulse(modeKey);
                    modeKey = -1;
                }

            }
            else if(state == 1)
            {
                if(modeKey >= 0)
                {
                    
                    // auto mode
                    if( cTime-lastAutoThick > autoDelay)
                    {
                        // send next signal
                        //Serial.println("auto mode: "+ String(modeKey) );
                        transceiver.pulse(modeKey);
                        display.pulse(modeKey);
                        state = 2;

                        lastAutoThick = cTime;
                    }
                }
            }

        break;
        case 2:
            // play back

            if( display.isOn(modeKey) && blinkCounter > BLINKSPEED_PLAYBACK)
            {
                display.on(modeKey,0);
                blinkCounter = 0;
            }
            else if( !display.isOn(modeKey) && blinkCounter > BLINKSPEED_PLAYBACK)
            {
                blinkCounter = 0;
                display.on(modeKey,1);
            }

            if(keyboard.pressed(0,false) == 2)
            {
                enterLeaveMenu();
                break;
            }

            else if(keyboard.pressed(0,false) == 1 || 
            keyboard.pressed(1,false) == 1 ||
            keyboard.pressed(2,false) == 1 || 
            keyboard.pressed(3,false) == 1)
            {

                display.off();
                state = 0;
                modeKey = -1;
                break;
            }


            if( !digitalRead(PIN_KEY_PTT) )
            {
                // Transceiver is sending audio file

            }
            else
            {
                // playback stopped
                lastAutoThick = cTime;
                //Serial.println("start timer for next playback");
                state = 3;
            }

        break;
        case 3:

            if( display.isOn(modeKey) && blinkCounter > BLINKSPEED_WAIT)
            {
                display.on(modeKey,0);
                blinkCounter = 0;
            }
            else if( !display.isOn(modeKey) && blinkCounter > BLINKSPEED_WAIT)
            {
                blinkCounter = 0;
                display.on(modeKey,1);
            }

            if(keyboard.pressed(0,false) == 2)
            {
                enterLeaveMenu();
                break;
            }

            else if(!digitalRead(PIN_KEY_PTT)  ||
            keyboard.pressed(0,false) == 1 || 
            keyboard.pressed(1,false) == 1 ||
            keyboard.pressed(2,false) == 1 || 
            keyboard.pressed(3,false) == 1)
            {

                display.off();
                state = 0;
                modeKey = -1;
                break;
            }
            // start next playback
            if( cTime-lastAutoThick > autoDelay)
            {
                // send next signal
                //Serial.println("start next playback: "+ String(modeKey) );
                transceiver.pulse(modeKey);
                state = 2;
                lastAutoThick = cTime;
            }
        
        break;
        case 10:
            // menu loop
            
            if(keyboard.pressed(0,false) == 2)
            {
                enterLeaveMenu();
                break;
            }

            else if(keyboard.pressed(0,false) == 1)
            {
                if(display.isOn(0))
                    display.on(0,0);
                else
                    display.on(0,1);
                // turn led on
                // manipulate delay time
            }
            else if(keyboard.pressed(1,false) == 1)
            {
                if(display.isOn(1))
                    display.on(1,0);
                else
                    display.on(1,1);                
                // turn led on
                // manipulate delay time
            }
            else if(keyboard.pressed(2,false) == 1)
            {
                if(display.isOn(2))
                    display.on(2,0);
                else
                    display.on(2,1);
                // turn led on
                // manipulate delay time
            }
            else if(keyboard.pressed(3,false) == 1)
            {
                if(display.isOn(3))
                    display.on(3,0);
                else
                    display.on(3,1);
                // turn led on
                // manipulate delay time
            }
            
        break;
    }
    blinkCounter++;
    keyboard.deletePressedStates();

}