#include <Arduino.h>
#include "Configuration.h"
#include "Display.h"

Display::Display()
{

}

void Display::init()
{
    mode = 0;
    larsonDirection = 0;
    larsonOn = 0;

    pinMode(PIN_LED_0, OUTPUT);
    pinMode(PIN_LED_1, OUTPUT);
    pinMode(PIN_LED_2, OUTPUT);
    pinMode(PIN_LED_3, OUTPUT);

    off();
}

void Display::on(unsigned int addr, int on)
{
    switch(addr)
    {
        case 0:
            digitalWrite(PIN_LED_0, on);
            break;
        case 1:
            digitalWrite(PIN_LED_1, on);
            break;
        case 2:
            digitalWrite(PIN_LED_2, on);
            break;
        case 3:
            digitalWrite(PIN_LED_3, on);
            break;
    }
    state[addr] = on;
}

bool Display::isOn(unsigned int addr)
{
    return state[addr] == 1;
}

void Display::larson(bool on = true)
{
    if(on)
        mode = 1;
    else
        mode = 0;
}

void Display::off()
{
    on(0,0);
    on(1,0);
    on(2,0);
    on(3,0);
}

void Display::pulse(unsigned int i )
{
    on(i,1);
    delay(200);
    on(i,0);
}

void Display::larson1(int qty=1)
{
    // turn all off
    off();

    int speed = 100;
    for( int i = 0; i < qty; i++)
    {

        for( int j = 0; j <= 3; j++)
        {
            on(j,1);
            delay(speed);
            on(j,0);    
        }

        for( int j = 3; j >= 0; j--)
        {
            on(j,1);
            delay(speed);
            on(j,0);    
        }

    }
}

void Display::main()
{
    unsigned long cTime = millis();

    // Nothing to do
    if(mode == 0)
        return;

    if(mode == 1)
    {
        if( cTime-lastMain < 50)
            return;

        if(larsonDirection == 0)
        {
            if(larsonOn<3)
            {
                on(larsonOn,false);
                on(++larsonOn,true);
            }
            else
            {
                larsonDirection = 1;
            }
        }
        else
        {
            if(larsonOn>0)
            {
                on(larsonOn,false);
                on(--larsonOn,true);
            }
            else
            {
                larsonDirection = 0;
            }

        }

    }

    lastMain = cTime;
    return;

}