#include <Arduino.h>
#include "Keyboard.h"
#include "Configuration.h"

Keyboard::Keyboard()
{  

}

void Keyboard::init()
{

    presstimes[0] = 0;
    presstimes[1] = 0;
    presstimes[2] = 0;
    presstimes[3] = 0;

    releasetimes[0] = 0;
    releasetimes[1] = 0;
    releasetimes[2] = 0;
    releasetimes[3] = 0;

    downDurations[0] = 0;
    downDurations[1] = 0;
    downDurations[2] = 0;
    downDurations[3] = 0;

    qtyPresses[0] = 0;
    qtyPresses[1] = 0;
    qtyPresses[2] = 0;
    qtyPresses[3] = 0;

    
    pinMode(PIN_KEY_0, INPUT_PULLUP);
    pinMode(PIN_KEY_1, INPUT_PULLUP);
    pinMode(PIN_KEY_2, INPUT_PULLUP);
    pinMode(PIN_KEY_3, INPUT_PULLUP);
}

bool Keyboard::isLongDown(int key)
{
    if(presstimes[key]==0)
        return false;

    unsigned long cTime = millis();
    return cTime-presstimes[key]>LONG_CLICK_DURATION;

}

void Keyboard::processKey(unsigned long time, int keyIndex, byte pin, byte downState)
{
    if (digitalRead(pin) == downState){
        if(presstimes[keyIndex] == 0 && time-releasetimes[keyIndex] > DEBOUNCE_TIME)
        {
            // key new down
            presstimes[keyIndex] = time;
            downDurations[keyIndex] = 0;
            qtyPresses[keyIndex]++;
        }
    }
    else
    {
        if(presstimes[keyIndex] != 0 && time-releasetimes[keyIndex] > DEBOUNCE_TIME)
        {
            // new up
            downDurations[keyIndex] = time-presstimes[keyIndex];
            releasetimes[keyIndex] = time;
            presstimes[keyIndex] = 0;
        }
        //downDurations[keyIndex] = time-presstimes[keyIndex];
    }

    //
    // Processing down durations
    //

    if(downDurations[keyIndex] > LONG_CLICK_DURATION && time-releasetimes[keyIndex] > DOUBLE_CLICK )
    {
        // long click
        //Serial.println("Key long:  "+ String(keyIndex) );
        //Serial.println(qtyPresses[keyIndex]);
        
        longPressedKeys[keyIndex] = qtyPresses[keyIndex];

        downDurations[keyIndex] = 0;
        releasetimes[keyIndex] = 0;
        qtyPresses[keyIndex] = 0;
    }
    else if(downDurations[keyIndex] > 0  && time-releasetimes[keyIndex] > DOUBLE_CLICK )
    {
        // normal click
        //Serial.println("Key short: "+ String(keyIndex) );
        //Serial.println(qtyPresses[keyIndex]);

        shortPressedKeys[keyIndex] = qtyPresses[keyIndex];

        downDurations[keyIndex] = 0;
        releasetimes[keyIndex] = 0;
        qtyPresses[keyIndex] = 0;
    }

}

void Keyboard::main()
{
    
    // Current time
    unsigned long cTime = millis();

    processKey( cTime, 0, PIN_KEY_0, KEY_0_PRESSED_STATE );
    processKey( cTime, 1, PIN_KEY_1, KEY_1_PRESSED_STATE );
    processKey( cTime, 2, PIN_KEY_2, KEY_2_PRESSED_STATE );
    processKey( cTime, 3, PIN_KEY_3, KEY_3_PRESSED_STATE );

}

int Keyboard::pressed(int key, bool longPressed)
{
    if(longPressed)
    {
        return longPressedKeys[key];
    }
    
    return shortPressedKeys[key];
    
}

void Keyboard::deletePressedStates()
{
    shortPressedKeys[0] = 0;
    shortPressedKeys[1] = 0;
    shortPressedKeys[2] = 0;
    shortPressedKeys[3] = 0;

    longPressedKeys[0] = 0;
    longPressedKeys[1] = 0;
    longPressedKeys[2] = 0;
    longPressedKeys[3] = 0;

}