/*
   Erstellt:  2021-01-23
   Autor:  Roland Kaiser, OE2ROL
   geschrieben für Arduino Nano ATmega 328P(Old Bootloader)
   Der Autor übernimmt keine Haftung etwaiger Folgeschäden an Transceivern oder dgl.
   
   Diese Software ist für den eigenen privaten Gebrauch frei verfügbar, jedoch nicht für kommerzielle Zwecke ohne Genehmigung des Autors.
   Veränderungen und Verbesserungen der Software bitte wieder an den Autor Roland Kaiser OE2ROL (roland.kaiser@sbg.at) senden.
   
   vielen Dank auch an den Autor der Library FT857D.h James Buck, VE3BUX
   
   Die Software wurde am Yaesu FT817 getestet, passt auch für FT857, FT897. Sollte auch an FT817ND, FT818 funktionieren.

   Funktionsweise:
   
   o  Der Transceiver wird beim Start automatisch in den entsptechenden "SAT Mode" gebracht (beide VFO´s in die vorgegebene QRG, Betriebsart USB, Splitmode, RX auf 70cm, TX auf 2m)
   o  Der 70cm VFO wird gelesen, davon wird ein vorgegebener Versatz subtrahiert und verzögert automatisch in den 2m VFO geschrieben.
   o  Dies passiert vollautomatisch nur durch verändern des 70cm VFO´s.
   o  Die für QO-100 umgerechnete RX und TX Frequenz wird auf einem LCD Display angezeigt. 
   o  RIT mit Tasten up oder down um 100 Hz verstellen
   o  Menüsteuerung mit 4 Ebenen:
       o Setzen eines RX-Offsets 100 Hz Schrittweite zum Anpassen von Ungenauigkeiten des Upconverters
       o Setzen eines TX-Offsets  10 Hz Schrittweite zum Anpassen von Ungenauigkeiten des Downconverters
       o Setzen eines Split-Offsets 1000Hz Schrittweite für Stationen die im Split-Betrieb arbeiten
       o Speichern der RX/TX Offsets im internen EEPROM.
   o  Nach dem Speichern der Offsets wird bei einem Neustart der SAT BOX auf die Frequenz der mittleren QO-100 Bake gestellt.
   o  Die RX und TX Offsets bleiben auch ohne Stromversorgung gespeichert, der Split Offset wird wieder auf 0 gesetzt.
   o  Nach erneuten Start werden die Offsets automatisch aus dem EEPROM ausgelesen und für die Korrektur des Up- und Down-Konverters wieder verwendet.

   Anschlussbelegung der Ports:
   
   Radio CAT port GND -> Arduino GND
   Radio CAT port TX  -> Arduino pin 11
   Radio CAT port RX  -> Arduino pin 12

   Tastenport up      -> Arduino Pin A3
   Tastenport down    -> Arduino Pin A4
   Tastenport Menü    -> Arduino Pin A5
   Die Tasten werden gegen Masse angeschlossen.

   Display:     Arduino:
   4(RS)    ->  7
   6(E)     ->  10
   11(D4)   ->  5
   12(D5)   ->  4
   13(D6)   ->  6
   14(D7)   ->  2
*/

#include <FT857D.h>    
#include <LiquidCrystal.h>
#include <EEPROM.h>

byte lcdNumCols = 20;           // LCD Anzahl der Stellen

LiquidCrystal lcd(7, 10, 5, 4, 6, 2); // LCD Anschlussbelegung 

uint32_t freq;                    // Current frequency in Hz
uint32_t VFO2;                    // 2m Frequenz
uint32_t VFO70;                   // 70cm Frequenz
uint32_t TXfreq;                  // umgerechnete Sendefrequenz zur Anzeige am LCD Display
uint32_t RXfreq;                  // umgerechnete Empfangsfrequenz zur Anzeige am LCD Display
uint32_t TXosz;                   // TX Oszillatorfrequenz
uint32_t RXosz;                   // RX Oszillatorfrequenz
uint32_t shift;                   // 2m 70cm Versatz
uint32_t freqmem;                 // FrequenzSpeicher
long RIT = 0;                     // RIT
long TXoffset;                    // TX Offset
long RXoffset;                    // RX Offset
long Splitoffset;                 // Split Offset
const int menuPin = A5;           // Pin für Menue Taste
const int downpin = A4;           // Pin für Up Taste
const int uppin = A3;             // Pin für Down Taste
int menuPushCounter = 0;          // Menütastenzähler
int menuState = 0;                // Menüstatus
int lastmenuState = 0;            // letzter Menü Status
boolean menubool = false;         // Menü initial deaktivieren
int upState;                      // up Status 
int lastupState;                  // letzter up Status
int up;                           // up Taste
int downState;                    // down Status
int lastdownState;                // letzter down Status
int down;                         // Taste down
int menucounter = 0;              // Menü Zähler
unsigned long previousMillis = 0; // Timer auf 0 setzen
const long interval = 5000;       // Verzögerungszeit zum VFO nachziehen

FT857D radio;                     // definition "radio" um CAT Kommandos zu senden
                  
void setup() {


/*
// ************   Wird nur bei der  1. Initialisierung einen neuen Arduino verwendet dann deaktivieren um die Offsets aus dem eeprom zu verwenden **************
TXoffset=0;
RXoffset=0;
EEPROM.put(0, TXoffset);                  // TX Offset Wert 0 ins eeprom schreiben (Adresse 0) 
delay(200);                               // Verzögerung
EEPROM.put(10, RXoffset);                 // Wert ins eeprom schreiben (Adresse 10)
*/

TXosz=2256000000;                               // TX Oszillatorfrequenz [Hz]    (z.B. 2256MHz für 2m)
RXosz=1005770000;                               // RX Oszillatorfrequenz [Hz*10] (z.B. 10,0577GHz 70cm)

pinMode(menuPin, INPUT);                        // Init für die Tasten Pins
digitalWrite(menuPin, HIGH);                    // Init für die Tasten Pins
pinMode(downpin, INPUT);                        // Init für die Tasten Pins
digitalWrite(downpin, HIGH);                    // Init für die Tasten Pins
pinMode(uppin, INPUT);                          // Init für die Tasten Pins
digitalWrite(uppin, HIGH);                      // Init für die Tasten Pins

lcd.begin(2, lcdNumCols);                       // LCD init
lcd.clear();                                    // LCD löschen
delay(100);                                     // Verzögerung

// Initmeldung
lcd.setCursor(0, 0);                            // 1. Zeichen, 1. Zeile
lcd.print(" **** SAT  BOX ****");               // schreiben
lcd.setCursor(0, 1);                            // 1. Zeichen, 2. Zeile
lcd.print("  **** OE2ROL ****");                // schreiben
delay(2000);                                    // Wartezeit
lcd.clear();                                    // LCD löschen

// CAT Settings beim Start setzen

Serial.begin(9600);                             // Serial.begin(9600) für Testzwecke 
radio.begin(9600);                              // CAT Einstellung am Tranceiver 9600

int dly = 50;                                   // Verzögerung für x millisekunden zwischen den Kommandos
RXoffset = EEPROM.get(10, RXoffset);            // RX Offset [Hz] aus dem eeprom lesen
radio.lock(false);                              // unlock Tranceiver
delay(dly); 
radio.clar(false);                              // disable clarifier 
delay(dly);
radio.squelch("OFF");                           // clear CTCSS & DCS squelch
delay(dly);
radio.split(true);                              // enable split mode
delay(dly); 
radio.setFreq(14425000);                        // 2m VFO Startfrequenz setzen (mittlere Bake QO-100)
delay(dly);
radio.setMode("USB");                           // mode auf USB setzen
delay(dly);
radio.switchVFO();                              // VFO umschalten A/B
delay(dly);
radio.setFreq((43205000)+(RXoffset/10));        // 70cm VFO Startfrequenz setzen (mittlere Bake QO-100)
delay(dly);
radio.setMode("USB");                           // mode auf USB setzen
delay(dly);

}
// LCD Beschriftung setzen

void LCDBeschriftung(void) {
lcd.setCursor(0, 0);      // 1. Zeichen, 1. Zeile
lcd.print("RX");          // schreiben
lcd.setCursor(17, 0);     // 18. Zeichen, 1. Zeile
lcd.print("MHz");         // schreiben
lcd.setCursor(0, 1);      // 1. Zeichen, 2. Zeile
lcd.print("TX");          // schreiben
lcd.setCursor(17, 1);     // 18. Zeichen, 2. Zeile
lcd.print("MHz");         // schreiben
//lcd.setCursor(18, 2);   // 1. Zeichen, 3. Zeile
//lcd.print("FWD");       // schreiben
//lcd.setCursor(18, 3);   // 1. Zeichen, 4. Zeile
//lcd.print("REF");       // schreiben
}

void calculateFrequency(void)  {
TXoffset = EEPROM.get(0, TXoffset);               // TX Offset zum Kalibrieren der Sendefrequenz [Hz] aus dem eeprom lesen (Adresse 0)
RXoffset = EEPROM.get(10, RXoffset);              // RX Offset zum Kalibrieren der Empfangsfrequenz [Hz] aus dem eeprom lesen (Adresse 10)
shift=287800000-(TXoffset)+(RXoffset);            // 2m 70cm Versatz [Hz*10] = TX 2400,250MHz RX 10489,750MHz = RX-TX shift 8,089.500GHz = Diff Uplink und Downlink QO100
TXfreq=(VFO2*10)+(TXosz)-(TXoffset);              // Berechnung der Sendefrequenz (Sendefreq.2m + Oszillatorfreq.TX)
RXfreq=(VFO70)+(RXosz)-(RXoffset/10);             // Berechnung der Empfangsfrequenz (Empanfsfreq.70cm + Oszillatorfreq.RX)
}

//display TX Frequenz (Uplink)
void displayTXfreq(void) {
lcd.setCursor(4, 1);
lcd.print(TXfreq/1000000000%10);   // Tx 1G Stelle ausgeben
lcd.setCursor(5, 1);
lcd.print(TXfreq/100000000%10);    // Tx 100M  Stelle ausgeben
lcd.setCursor(6, 1);
lcd.print(TXfreq/10000000%10);     // Tx 10M Stelle ausgeben
lcd.setCursor(7, 1);
lcd.print(TXfreq/1000000%10);      // Tx 1M Stelle ausgeben
lcd.setCursor(8, 1);
lcd.print(",");                    // , ausgeben
lcd.setCursor(9, 1);
lcd.print(TXfreq/100000%10);       // Tx 100k Stelle ausgeben
lcd.setCursor(10, 1);
lcd.print(TXfreq/10000%10);        // Tx 10k Stelle ausgeben
lcd.setCursor(11, 1);
lcd.print(TXfreq/1000%10);         // Tx 1k Stelle ausgeben
lcd.setCursor(12, 1);
lcd.print(TXfreq/100%10);          // Tx 100Hz Stelle ausgeben
lcd.setCursor(13, 1);
lcd.print(TXfreq/10%10);           // Tx 10Hz Stelle ausgeben
lcd.setCursor(14, 1);
lcd.print(TXfreq%10);              // Tx 1Hz Stelle ausgeben
}

//display RX Frequenz (Downlink)
void displayRXfreq(void) {
lcd.setCursor(1, 2);
lcd.print(RXfreq/1000000000%10);   // Rx 10G Stelle ausgeben
lcd.setCursor(2, 2);
lcd.print(RXfreq/100000000%10);    // Rx 1G Stelle ausgeben
lcd.setCursor(3, 2);
lcd.print(RXfreq/10000000%10);     // Rx 100M Stelle ausgeben
lcd.setCursor(4, 2);
lcd.print(RXfreq/1000000%10);      // Rx 10M Stelle ausgeben
lcd.setCursor(5, 2);
lcd.print(RXfreq/100000%10);       // Rx 1M Stelle ausgeben
lcd.setCursor(6, 2);
lcd.print(",");                    // , ausgeben
lcd.setCursor(7, 2);
lcd.print(RXfreq/10000%10);        // Rx 100k Stelle ausgeben
lcd.setCursor(8, 2);
lcd.print(RXfreq/1000%10);         // Rx 10k Stelle ausgeben
lcd.setCursor(9, 2);
lcd.print(RXfreq/100%10);          // Rx 1k Stelle ausgeben
lcd.setCursor(10, 2);
lcd.print(RXfreq/10%10);           // Rx 100Hz Stelle ausgeben
lcd.setCursor(11, 2);
lcd.print(RXfreq%10);              // Rx 10Hz Stelle ausgeben
lcd.setCursor(12, 2);
lcd.print(RXfreq%1);               // Rx 1Hz Stelle ausgeben
}

// Nachziehen des 2.VFO

void VFOnachziehen() {
int dly = 10;                                   // Verzögerung für x millisekunden zwischen den Kommandos
freq = (radio.getFreqMode());                   // Frequenz aus dem Tranceiver lesen
if (freq>15000000)                  // zur Unterdrückung einer falschen Displayanzeige beim Senden nur wenn die TX Frequenz > als 2399 MHz ist dann: 
      {
       VFO2=(freq)-(shift/10)-(RIT)+(Splitoffset/10);  // VFO Freq. für 2m berechnen und um RIT korrigieren
         unsigned long currentMillis = millis();         // Wert für aktuellen Timer setzen 
          if (currentMillis - previousMillis >= interval) // wenn Differenz des aktuellen Timers zu Startwert des Timers > Verzögerungszeit ist, dann:
            {
               previousMillis = currentMillis;              // Timerstartwert auf Wert des aktuellen Timers setzen
               if (freqmem!=VFO2)                      // Nur wenn der Zwischenspeicher nicht dem VFO der 2m Frequenz entspricht, dann:
                  {
                   radio.switchVFO();                   // VFO umschalten von 70cm auf 2m
                   delay(dly);                          // Verzögerung
                   radio.setFreq(VFO2);                 // VFO mit der neuen 2m Frequenz beschreiben
                   freqmem=VFO2;                        // 2m Frequenz in den Zwischenspeicher schreiben
                   delay(dly);                          // Verzögerung
                   radio.switchVFO();                   // VFO umschalten von 2m auf 70cm
                  } 
            }
       }
delay(dly);                                             // Verzögerung
VFO70 = (radio.getFreqMode());                          // VFO Freq. für 70cm vom Tranceiver lesen 
}

void RXkorr()
{
up = digitalRead(uppin);                        // up Taste abfragen
            if (up == LOW)                      // wenn up Taste betätigt
            {
              delay(200);                       // Verzögerung
              RIT=RIT+10;                       // RIT um 100 Hz erhöhen
              radio.setFreq(VFO70+10);          // VFO mit der neuen 70cm Frequenz beschreiben
              lcd.clear();                      // LCD löschen
              lcd.setCursor(0, 0);              // 1. Zeichen, 1. Zeile
              lcd.print("RIT [Hz]");            // schreiben
              lcd.setCursor(0, 1);              // 1. Zeichen, 2. Zeile
              lcd.print(RIT*10);                // schreiben
              delay(500);                       // Verzögerung
              lcd.clear();                      // LCD löschen
            }
down = digitalRead(downpin);                    // down Taste abfragen
            if (down == LOW)                    // wenn down Taste betätigt
            {
              delay(200);                       // Verzögerung
              RIT=RIT-10;                       // RIT um 100 Hz vermindern
              radio.setFreq(VFO70-10);          // VFO mit der neuen 70cm Frequenz beschreiben
              lcd.clear();                      // LCD löschen
              lcd.setCursor(0, 0);              // 1. Zeichen, 1. Zeile
              lcd.print("RIT [Hz]");            // schreiben
              lcd.setCursor(0, 1);              // 1. Zeichen, 2. Zeile
              lcd.print(RIT*10);                // schreiben
              delay(500);                       // Verzögerung
              lcd.clear();                      // LCD löschen
            }
}
  
void loop() {         
int dly = 5;                            // Verzögerung für x millisekunden zwischen den Kommandos
LCDBeschriftung();                      // LCD Beschriftung ausführen
calculateFrequency();                   // Frequenzberechnung durchführen
if (TXfreq>2399000000)                  // zur Unterdrückung einer falschen Displayanzeige beim Senden nur wenn die TX Frequenz > als 2399 MHz ist dann: 
      {
       displayTXfreq();                 // TX Frequenz ins Display schreiben
      }
if (RXfreq>1048800000)                  // zur Unterdrückung einer falschen Displayanzeige beim Senden nur wenn die RX Frequenz  > als 10,488 GHz ist dann: 
      {
       displayRXfreq();                 // RX Frequenz ins Display schreiben
      }
VFOnachziehen();                        // VFO nachziehen
RXkorr();                               // RIT ausführen
//Serial.println(RXfreq);               // nur für Testzwecke
//Serial.println(TXfreq);               // nur für Testzwecke
//Serial.println(VFO70);                // nur für Testzwecke
//Serial.println(VFO2);                 // nur für Testzwecke
//Serial.println(TXoffset);             // nur für Testzwecke
//Serial.println(RXoffset);             // nur für Testzwecke
//Serial.println(freq);                 // nur für Testzwecke
delay(dly);                             // Verzögerung

menuState = digitalRead(menuPin);                       // prüfen ob die Menütaste gedrückt ist
  if (menuState != lastmenuState)                       // wenn sich der Menü Status geändert hat
  {
    if (menuState == LOW)                               // wenn Menü Status LOW
    {
      delay(200);                                       // Verzögerung
      menuPushCounter = 4;                              // maximal 4 Menüs verfügbar Menütastenzähler auf 4 setzen
      menubool = true;                                  // menü aktivieren
    }
    if (menuState == HIGH)                              // wenn Menü Status HIGH
    {
      menubool = false;                                 // menü deaktivieren
    }
  }

  if (menubool == true && menuPushCounter == 4)         // wenn Menü aktiviert und Menütastenzähler 4
  {
    menucounter = 0;                                    // Menüzähler auf 0 setzen 
    menu();                                             // Menü starten
  }
lastmenuState = menuState;
}

// Menüsteuerung zum Setzen und Speichern der Offsets

int menu()
{
  lcd.clear();                                    // LCD löschen
  delay(100);                                     // Verzögerung
  while (menucounter < 4)                         // while Menu enspricht der max Anzahl der Menüs
  {
    menuState = digitalRead(menuPin);             // Menü Taste abfragen
    up = digitalRead(uppin);                      // up Taste abfragen
    down = digitalRead(downpin);                  // down Taste abfragen

    if (menuState != lastmenuState)               // wenn sich der Menü Status geändert hat
    {
      lcd.clear();                                // LCD löschen
      if (menuState == LOW)                       // wenn Menü Status LOW
      {
        delay(200);                               // Verzögerung
        menucounter++;                            // Menüzähler um 1 erhöhen
      }
    }
lastmenuState = menuState;                        // letzten Menüstatus auf Menü Status setzen
   
                                                  // zeigt die Menüs

    switch (menucounter) {                        // Menüauswahl
      case 0:                                     // Menü 1 TX Offset
        lcd.setCursor(0, 0);                      // 1. Zeichen, 1. Zeile
        lcd.print("TX Offset [Hz]");              // schreiben
        lcd.setCursor(0, 1);                      // 1. Zeichen, 2. Zeile
        lcd.print(TXoffset);                      // schreiben
            if (up == LOW)                        // wenn up Taste betätigt
            {
              delay(200);                         // Verzögerung
              TXoffset=TXoffset+10;               // Wert um 10 erhöhen
              lcd.clear();                        // LCD löschen
            }
            if (down == LOW)                      // wenn down Taste betätigt
            {
              delay(200);                         // Verzögerung
              TXoffset=TXoffset-10;               // Wert um 10 vermindern
              lcd.clear();                        // LCD löschen
            }
        break;                                    // aussteigen, dieses Menü beginnt dann von vorne

      case 1:                                     // Menü 2 RX Offset
        lcd.setCursor(0, 0);                      // 1. Zeichen, 1. Zeile
        lcd.print("RX Offset [Hz]");              // schreiben
        lcd.setCursor(0, 1);                      // 1. Zeichen, 2. Zeile
        lcd.print(RXoffset);                      // schreiben
            if (up == LOW)                        // wenn up Taste betätigt
            {
              delay(200);                         // Verzögerung
              RXoffset=RXoffset+100;              // Wert um 100 erhöhen
              lcd.clear();                        // LCD löschen
            }
            if (down == LOW)                      // wenn down Taste betätigt
            {
              delay(200);                         // Verzögerung
              RXoffset=RXoffset-100;              // Wert um 100 vermindern
              lcd.clear();                        // LCD löschen
            }
        break;                                    // aussteigen, dieses Menü beginnt dann von vorne
        
      case 2:                                     // Menü 2 Split Offset
        lcd.setCursor(0, 0);                      // 1. Zeichen, 1. Zeile
        lcd.print("Split Offset [Hz]");           // schreiben
        lcd.setCursor(0, 1);                      // 1. Zeichen, 2. Zeile
        lcd.print(Splitoffset);                   // schreiben
            if (up == LOW)                        // wenn up Taste betätigt
            {
              delay(200);                         // Verzögerung
              Splitoffset=Splitoffset+1000;       // Wert um 1000 erhöhen
              lcd.clear();                        // LCD löschen
            }
            if (down == LOW)                      // wenn down Taste betätigt
            {
              delay(200);                         // Verzögerung
              Splitoffset=Splitoffset-1000;       // Wert um 1000 vermindern
              lcd.clear();                        // LCD löschen
            }
        break;                                    // aussteigen, dieses Menü beginnt dann von vorne
        
      case 3:                                     // Menü 3, hier werden die Werte gespeichert und der arduino beginnt loop neu auszuführen
        lcd.setCursor(0, 0);                      // 1. Zeichen, 1. Zeile
        lcd.print("store RX/TX Offsets?");        // schreiben
        lcd.setCursor(0, 1);                      // 1. Zeichen, 2. Zeile
        lcd.print("down= No     up= Yes");        // schreiben
            if (up == LOW)                        // wenn up Taste betätigt
            {
              delay(200);                         // Verzögerung
              EEPROM.put(0, TXoffset);            // Wert ins eeprom schreiben (Adresse 0)
              delay(200);                         // Verzögerung
              EEPROM.put(10, RXoffset);           // Wert ins eeprom schreiben (Adresse 10)
              delay(200);                         // Verzögerung
              lcd.setCursor(0, 1);                // 1. Zeichen, 1. Zeile
              lcd.clear();                        // LCD löschen
              lcd.print("Offsets stored");        // schreiben
              delay(2000);                        // Verzögerung
              lcd.clear();                        // LCD löschen
              delay(200);                         // Verzögerung
              menucounter = 4;                    // Menü Zähler auf 4 setzen
              menuPushCounter = 0;                // Menütastenzähler auf 0 setzen
              break;                              // aussteigen, zurück zu loop
            }
            if (down == LOW)                      // wenn down Taste betätigt
            {
              lcd.clear();                        // LCD löschen
              delay(200);                         // Verzögerung
              menucounter = 4;                    // Menü Zähler auf 4 setzen
              menuPushCounter = 0;                // Menütastenzähler auf 0 setzen
              break;                              // aussteigen, zurück zu loop
            }
    }
  }
}
