/*
   Erstellt:  2023-10-27
   Version V5.1
   Autor:  Roland Kaiser, OE2ROL
   vielen Dank auch an den Autor der Library FT857D James Buck, VE3BUX
   geschrieben für Arduino Nano ATmega 328P(Old Bootloader)
   Der Autor übernimmt keine Haftung etwaiger Folgeschäden an Transceivern oder dgl.
   
   Diese Software ist für den eigenen privaten Gebrauch frei verfügbar, jedoch nicht für kommerzielle Zwecke ohne Genehmigung des Autors.
   Veränderungen und Verbesserungen der Software bitte wieder an den Autor Roland Kaiser OE2ROL (roland.kaiser@sbg.at) senden.
   Die Software wurde am Yaesu FT817 getestet, passt auch für FT857, FT897. Sollte auch mit FT817ND, FT818 funktionieren.

   Funktionsweise:
   
   o  Der Transceiver wird beim Start automatisch in den entsptechenden "SAT Mode" gebracht (beide VFO´s in die vorgegebene QRG, Betriebsart USB, Splitmode)
   o  Der RX VFO wird gelesen, davon wird ein vorgegebener Versatz subtrahiert und verzögert automatisch in den TX VFO geschrieben.
   o  Dies passiert vollautomatisch nur durch verändern des RX VFO´s.
   o  Die für QO-100 umgerechnete RX und TX Frequenz wird auf einem LCD Display angezeigt. 
   o  RIT kann mit Tasten up oder down um die voreingestellte Schrittweite verstellt werden (hier wird nur die Empfangsfrequenz verändert)
   o  Menüsteuerung in 5 Ebenen:
       o Setzen der RX-Oszillatorfrequenz mit voreingestellter Schrittweite zum Anpassen der Oszillatorfrequenz des Upconverters
       o Setzen der TX-Oszillatorfrequenz mit voreingestellter Schrittweite zum Anpassen der Oszillatorfrequenz des Downconverters
       o Setzen eines Split-Offsets mit voreingestellter Schrittweite für Stationen die im Split-Betrieb arbeiten (hier wird nur die Sendefrequenz verändert)
       o Setzen der Schrittweite für alle Einstellungen
       o Speichern der RX/TX Oszillatorfrequenzen im internen EEPROM.
   o  Nach dem Speichern der Oszillatorfrequenzen wird nach einem Neustart der SAT BOX die Frequenz auf die mittlere QO-100 Bake gestellt.
   o  Die RX und TX Oszillatorfrequenzen bleiben auch ohne Stromversorgung gespeichert, der Split Offset wird wieder auf 0 gesetzt.
   o  Nach erneuten Start werden die Offsets automatisch aus dem EEPROM ausgelesen und für die Korrektur des Up- und Down-Konverters wieder verwendet.
   o  Softwarereset kann mit Up- und Down-Taste gleichzeitig betätigen ausgelöst werden. (nur in der Frequenzanzeige)

   Änderungsübersicht:
   V5.1 Automatisches setzen der Oszillatorfrequenzen bei der  1. Initialisierung eines neuen Arduino
   V5.0 TX RX frei wählbar mit Eingabe entsprechender Oszillatorfrequenzen, Anzeige RX,TX Status hinzugefügt,   
   V4.0 TX 70cm_RX 70cm getestet (Unterdrückung einer falschen Frequenzanzeige bei TX nicht möglich
   V3.0 TX 2m_RX 70cm und TX 70cm_RX 2m Versionen zusammengeführt
   V2.2 TX 70cm RX 2m mit Eingabe der Oszillatorfrequenzen und Schrittweite, Softwarereset hinzugefügt
   V2.0 Initiale Version
   
   
   Anschlussbelegung der Ports:
   
   Radio CAT port GND -> Arduino GND
   Radio CAT port TX  -> Arduino pin 11
   Radio CAT port RX  -> Arduino pin 12

   Tastenport up      -> Arduino Pin A3
   Tastenport down    -> Arduino Pin A4
   Tastenport Menü    -> Arduino Pin A5
   Die Tasten werden gegen Masse angeschlossen.

   Display:     Arduino:
   4(RS)    ->  7
   6(E)     ->  10
   11(D4)   ->  5
   12(D5)   ->  4
   13(D6)   ->  6
   14(D7)   ->  2
*/
#include <FT857D_1.h> 
#include <LiquidCrystal.h>
#include <EEPROM.h>

byte lcdNumCols = 20;           // LCD Anzahl der Stellen

LiquidCrystal lcd(7, 10, 5, 4, 6, 2); // LCD Anschlussbelegung 

uint32_t freq;                    // gelesene Frequenz in Hz
uint32_t TVFO;                    // Sendefrequenz
uint32_t RVFO;                    // EmpfangsFrequenz
uint32_t TXfreq;                  // umgerechnete Sendefrequenz zur Anzeige am LCD Display
uint32_t RXfreq;                  // umgerechnete Empfangsfrequenz zur Anzeige am LCD Display
uint32_t TXosz;                   // TX Oszillatorfrequenz
uint32_t RXosz;                   // RX Oszillatorfrequenz
uint32_t shift;                   // RX-TX Frequenzversatz
uint32_t freqmem;                 // Frequenzzwischenspeicher
long RIT = 0;                     // RIT
long Splitoffset;                 // Split Offset
const int menuPin = A5;           // Pin für Menue Taste
const int downpin = A4;           // Pin für Up Taste
const int uppin = A3;             // Pin für Down Taste
int menuPushCounter = 0;          // Menütastenzähler
int menuState = 0;                // Menüstatus
int lastmenuState = 0;            // letzter Menü Status
boolean menubool = false;         // Menü initial deaktivieren
int up;                           // up Taste
int down;                         // Taste down
int menucounter = 0;              // Menü Zähler
unsigned long previousMillis = 0; // Timer auf 0 setzen
const long interval = 3000;       // Verzögerungszeit zum VFO nachziehen [ms]
uint32_t sw = 10;                 // Schrittweite zum Einstellen der Frequenzen im Menü Hz/10
uint32_t state;                   // RX,TX Status 0=RX, 1=TX


FT857D radio;                     // definition "radio" um CAT Kommandos zu senden
                  
void setup() {

  EEPROM.get(0, TXosz);
  if(TXosz == -1){
    // Wird nur bei der  1. Initialisierung eines neuen Arduino verwendet
    TXosz=2256000000;                               // TX Oszillatorfrequenz [Hz]    (z.B. 2256MHz)
    RXosz=1005400000;                               // RX Oszillatorfrequenz [Hz/10] (z.B. 10,054GHz)
    EEPROM.put(0, TXosz);                           // Wert TXosz ins EEPROM schreiben (Adresse 0) 
    delay(200);                                     // Verzögerung
    EEPROM.put(10, RXosz);                          // Wert RXosz ins EEPROM schreiben (Adresse 10)
    delay(200);                                     // Verzögerung
  }

pinMode(menuPin, INPUT);                        // Init für die Tasten Pins
digitalWrite(menuPin, HIGH);                    // Init für die Tasten Pins
pinMode(downpin, INPUT);                        // Init für die Tasten Pins
digitalWrite(downpin, HIGH);                    // Init für die Tasten Pins
pinMode(uppin, INPUT);                          // Init für die Tasten Pins
digitalWrite(uppin, HIGH);                      // Init für die Tasten Pins
lcd.begin(2, lcdNumCols);                       // LCD init
lcd.clear();                                    // LCD löschen
delay(100);                                     // Verzögerung


// Initmeldung
lcd.setCursor(0, 0);                            // 1. Zeichen, 1. Zeile
lcd.print(" **** SAT  BOX ****");               // schreiben
lcd.setCursor(0, 1);                            // 1. Zeichen, 2. Zeile
lcd.print("  **** OE2ROL ****");                // schreiben
lcd.setCursor(18, 2);                           // 1. Zeichen, 3. Zeile
lcd.print("FT-8x7 V5.1");                       // schreiben
delay(2000);                                    // Wartezeit
lcd.clear();                                    // LCD löschen

// CAT Settings beim Start setzen

Serial.begin(9600);                             // Serial.begin(9600) für Testzwecke 
radio.begin(9600);                              // CAT Einstellung am Tranceiver 9600

int dly = 50;                                   // Verzögerung für x millisekunden zwischen den Kommandos
RXosz = EEPROM.get(10, RXosz);                  // RX Oszillatorfrequenz [Hz/10] aus dem eeprom lesen
TXosz = EEPROM.get(0, TXosz);                   // TX Oszillatorfrequenz [Hz] aus dem eeprom lesen
radio.lock(false);                              // unlock Tranceiver
delay(dly); 
radio.clar(false);                              // disable clarifier 
delay(dly);
radio.squelch("OFF");                           // clear CTCSS & DCS squelch
delay(dly);
radio.split(true);                              // enable split mode
delay(dly); 
radio.setFreq((2400250000-TXosz)/10);           // TX VFO Startfrequenz setzen (mittlere Bake QO-100)
delay(dly);
radio.setMode("USB");                           // mode auf USB setzen
delay(dly);
radio.switchVFO();                              // VFO umschalten A/B
delay(dly);
radio.setFreq(1048975000-RXosz);                // RX VFO Startfrequenz setzen (mittlere Bake QO-100)
delay(dly);
radio.setMode("USB");                           // mode auf USB setzen
delay(dly);

}

// Softwarereset

void software_reset(){
up = digitalRead(uppin);                                // up Taste abfragen
down = digitalRead(downpin);                            // down Taste abfragen
            if (up == LOW && down == LOW){              // wenn up und down Taste gleichzeitig betätigt
              asm volatile ("  jmp 0");                 // Software Reset
            }
}

// LCD Beschriftung setzen

void LCDBeschriftung(void) {
lcd.setCursor(1, 0);      // 2. Zeichen, 1. Zeile
lcd.print("RX");          // schreiben
lcd.setCursor(17, 0);     // 18. Zeichen, 1. Zeile
lcd.print("MHz");         // schreiben
lcd.setCursor(1, 1);      // 2. Zeichen, 2. Zeile
lcd.print("TX");          // schreiben
lcd.setCursor(17, 1);     // 18. Zeichen, 2. Zeile
lcd.print("MHz");         // schreiben
}

void RXTXBeschriftung(void) {
state = (radio.chkTX());      // RX-TX Statusabfrage
  if (state == 0) {           // wenn state 0 ist (RX) dann
    lcd.setCursor(0, 0);      // 1. Zeichen, 1. Zeile
    lcd.print("*");           // schreiben
  }
  else{                       // sonst
    lcd.setCursor(0, 0);      // 1. Zeichen, 1. Zeile
    lcd.print(" ");           // schreiben
  }
  if (state == 1) {           // wenn state 1 ist (TX) dann
    lcd.setCursor(0, 1);      // 1. Zeichen, 2. Zeile
    lcd.print("*");           // schreiben
  }
  else{                       // sonst
    lcd.setCursor(0, 1);      // 1. Zeichen, 2. Zeile
    lcd.print(" ");           // schreiben
  }
}

void calculateFrequency(void)  {
TXosz = EEPROM.get(0, TXosz);               // TX Oszillatorfrequenz [Hz] aus dem eeprom lesen (Adresse 0)
RXosz = EEPROM.get(10, RXosz);              // RX Oszillatorfrequenz [Hz/10] aus dem eeprom lesen (Adresse 10)
shift=808950000;                            // QO-100 RX-TX Versatz [Hz/10] = TX 10489,750MHz RX 2400,250MHz = RX-TX shift 8089,500MHz
TXfreq=(TVFO*10)+TXosz;                     // Berechnung der SAT Sendefrequenz [Hz](Sendefrequenz + TX Oszillatorfrequenz)
RXfreq=RVFO+RXosz;                          // Berechnung der SAT Empfangsfrequenz [Hz/10](Empfangsfrequenz + RX Oszillatorfrequenz)
}

//display TX Frequenz (Uplink)
void displayTXfreq(void) {
  if (state == 0){                 // nur wenn der Transceiver im RX-Mode ist
lcd.setCursor(5, 1);
lcd.print(TXfreq/1000000000%10);   // Tx 1G Stelle ausgeben
lcd.setCursor(6, 1);
lcd.print(TXfreq/100000000%10);    // Tx 100M  Stelle ausgeben
lcd.setCursor(7, 1);
lcd.print(TXfreq/10000000%10);     // Tx 10M Stelle ausgeben
lcd.setCursor(8, 1);
lcd.print(TXfreq/1000000%10);      // Tx 1M Stelle ausgeben
lcd.setCursor(9, 1);
lcd.print(",");                    // , ausgeben
lcd.setCursor(10, 1);
lcd.print(TXfreq/100000%10);       // Tx 100k Stelle ausgeben
lcd.setCursor(11, 1);
lcd.print(TXfreq/10000%10);        // Tx 10k Stelle ausgeben
lcd.setCursor(12, 1);
lcd.print(TXfreq/1000%10);         // Tx 1k Stelle ausgeben
lcd.setCursor(13, 1);
lcd.print(TXfreq/100%10);          // Tx 100Hz Stelle ausgeben
lcd.setCursor(14, 1);
lcd.print(TXfreq/10%10);           // Tx 10Hz Stelle ausgeben
lcd.setCursor(15, 1);
lcd.print(TXfreq%10);              // Tx 1Hz Stelle ausgeben
  }
}

//display RX Frequenz (Downlink)
void displayRXfreq(void) {
  if (state == 0){                 // nur wenn der Transceiver im RX-Mode ist
lcd.setCursor(2, 2);
lcd.print(RXfreq/1000000000%10);   // Rx 10G Stelle ausgeben
lcd.setCursor(3, 2);
lcd.print(RXfreq/100000000%10);    // Rx 1G Stelle ausgeben
lcd.setCursor(4, 2);
lcd.print(RXfreq/10000000%10);     // Rx 100M Stelle ausgeben
lcd.setCursor(5, 2);
lcd.print(RXfreq/1000000%10);      // Rx 10M Stelle ausgeben
lcd.setCursor(6, 2);
lcd.print(RXfreq/100000%10);       // Rx 1M Stelle ausgeben
lcd.setCursor(7, 2);
lcd.print(",");                    // , ausgeben
lcd.setCursor(8, 2);
lcd.print(RXfreq/10000%10);        // Rx 100k Stelle ausgeben
lcd.setCursor(9, 2);
lcd.print(RXfreq/1000%10);         // Rx 10k Stelle ausgeben
lcd.setCursor(10, 2);
lcd.print(RXfreq/100%10);          // Rx 1k Stelle ausgeben
lcd.setCursor(11, 2);
lcd.print(RXfreq/10%10);           // Rx 100Hz Stelle ausgeben
lcd.setCursor(12, 2);
lcd.print(RXfreq%10);              // Rx 10Hz Stelle ausgeben
lcd.setCursor(13, 2);
lcd.print(RXfreq%1);               // Rx 1Hz Stelle ausgeben
  }
}

// Nachziehen des 2.VFO

void VFOnachziehen() {
int dly = 10;                                             // Verzögerung für x millisekunden zwischen den Kommandos
freq = (radio.getFreqMode());                             // Frequenz aus dem Tranceiver lesen
  if (state == 0){                                        // nur wenn der Transceiver im RX Mode ist
       TVFO=freq+RXosz-shift-(TXosz/10)-RIT+Splitoffset;  // VFO Freq. zum Senden berechnen [Hz/10](Empfangsfrequenz+RX Oszillatorfrequenz-shift-TX Oszillatorfrequenz) um RIT und Splitoffset korrigieren
         unsigned long currentMillis = millis();          // Wert für aktuellen Timer setzen 
          if (currentMillis - previousMillis >= interval) // wenn Differenz des aktuellen Timers zu Startwert des Timers > Verzögerungszeit ist, dann:
            {
               previousMillis = currentMillis;            // Timerstartwert auf Wert des aktuellen Timers setzen
               if (freqmem!=TVFO)                         // Nur wenn der Zwischenspeicher nicht dem SendeVFO entspricht, dann:
                  {
                   radio.switchVFO();                     // umschalten von EmpfangsVFO auf SendeVFO
                   delay(dly);                            // Verzögerung
                   radio.setFreq(TVFO);                   // SendeVFO mit der neuen Frequenz beschreiben
                   freqmem=TVFO;                          // SendeVFO in den Zwischenspeicher schreiben
                   delay(dly);                            // Verzögerung
                   radio.switchVFO();                     // umschalten von SendeVFO auf EmpfangsVFO
                  } 
            }
  }
delay(dly);                                               // Verzögerung
RVFO = (radio.getFreqMode());                             // EmpfangsVFO vom Tranceiver lesen 
}

void RXkorr()
{
up = digitalRead(uppin);                        // up Taste abfragen
            if (up == LOW)                      // wenn up Taste betätigt
            {
              delay(200);                       // Verzögerung
              RIT=RIT+sw;                       // RIT um Schrittweite erhöhen
              radio.setFreq(RVFO+sw);           // VFO mit der neuen Empfangsfrequenz beschreiben
              lcd.clear();                      // LCD löschen
              lcd.setCursor(0, 0);              // 1. Zeichen, 1. Zeile
              lcd.print("RIT [Hz]");            // schreiben
              lcd.setCursor(0, 1);              // 1. Zeichen, 2. Zeile
              lcd.print(RIT*10);                // schreiben
              delay(500);                       // Verzögerung
              lcd.clear();                      // LCD löschen
            }
down = digitalRead(downpin);                    // down Taste abfragen
            if (down == LOW)                    // wenn down Taste betätigt
            {
              delay(200);                       // Verzögerung
              RIT=RIT-sw;                       // RIT um Schrittweite vermindern
              radio.setFreq(RVFO-sw);           // VFO mit der neuen Empfangsfrequenz beschreiben
              lcd.clear();                      // LCD löschen
              lcd.setCursor(0, 0);              // 1. Zeichen, 1. Zeile
              lcd.print("RIT [Hz]");            // schreiben
              lcd.setCursor(0, 1);              // 1. Zeichen, 2. Zeile
              lcd.print(RIT*10);                // schreiben
              delay(500);                       // Verzögerung
              lcd.clear();                      // LCD löschen
            }
}
  
void loop() {         
int dly = 5;                            // Verzögerung für x millisekunden zwischen den Kommandos

LCDBeschriftung();                      // LCD Beschriftung ausführen
RXTXBeschriftung();                     // Beschriftung für den RX oder TX Status ausführen
calculateFrequency();                   // Frequenzberechnung ausführen
displayTXfreq();                        // TX Frequenz ins Display schreiben
displayRXfreq();                        // RX Frequenz ins Display schreiben
VFOnachziehen();                        // VFO nachziehen ausführen
RXkorr();                               // RIT ausführen
software_reset();                       // Software Reset ausführen



//Serial.println(state);                // nur für Testzwecke
//Serial.println(RXfreq);               // nur für Testzwecke
//Serial.println(TXfreq);               // nur für Testzwecke
//Serial.println(RXosz);                // nur für Testzwecke
//Serial.println(TXosz);                // nur für Testzwecke
//Serial.println(RVFO);                 // nur für Testzwecke
//Serial.println(TVFO);                 // nur für Testzwecke
//Serial.println(freqmem);              // nur für Testzwecke
//Serial.println(freq);                 // nur für Testzwecke
//Serial.println(shift);                // nur für Testzwecke
delay(dly);                             // Verzögerung

menuState = digitalRead(menuPin);                       // prüfen ob die Menütaste gedrückt ist
  if (menuState != lastmenuState)                       // wenn sich der Menü Status geändert hat
  {
    if (menuState == LOW)                               // wenn Menü Status LOW
    {
      delay(200);                                       // Verzögerung
      menuPushCounter = 5;                              // maximal 4 Menüs verfügbar Menütastenzähler auf 5 setzen
      menubool = true;                                  // menü aktivieren
    }
    if (menuState == HIGH)                              // wenn Menü Status HIGH
    {
      menubool = false;                                 // menü deaktivieren
    }
  }

  if (menubool == true && menuPushCounter == 5)         // wenn Menü aktiviert und Menütastenzähler 5
  {
    menucounter = 0;                                    // Menüzähler auf 0 setzen 
    menu();                                             // Menü starten
  }
lastmenuState = menuState;
}

// Menüsteuerung zum Setzen und Speichern der Offsets

int menu()
{
  lcd.clear();                                    // LCD löschen
  delay(100);                                     // Verzögerung
  while (menucounter < 5)                         // while Menu enspricht der max Anzahl der Menüs+1
  {
    menuState = digitalRead(menuPin);             // Menü Taste abfragen
    up = digitalRead(uppin);                      // up Taste abfragen
    down = digitalRead(downpin);                  // down Taste abfragen

    if (menuState != lastmenuState)               // wenn sich der Menü Status geändert hat
    {
      lcd.clear();                                // LCD löschen
      if (menuState == LOW)                       // wenn Menü Status LOW
      {
        delay(200);                               // Verzögerung
        menucounter++;                            // Menüzähler um 1 erhöhen
      }
    }
lastmenuState = menuState;                        // letzten Menüstatus auf Menü Status setzen
   
                                                  // zeigt die Menüs

    switch (menucounter) {                        // Menüauswahl
      case 0:                                     // Menü 1 TX Offset
        lcd.setCursor(0, 0);                      // 1. Zeichen, 1. Zeile
        lcd.print("TX Oszillator [Hz]");          // schreiben
        lcd.setCursor(0, 1);                      // 1. Zeichen, 2. Zeile
        lcd.print(TXosz);                         // schreiben
            if (up == LOW)                        // wenn up Taste betätigt
            {
              delay(200);                         // Verzögerung
              TXosz=TXosz+(sw*10);                // Wert um Schrittweite*10 erhöhen
              lcd.clear();                        // LCD löschen
            }
            if (down == LOW)                      // wenn down Taste betätigt
            {
              delay(200);                         // Verzögerung
              TXosz=TXosz-(sw*10);                // Wert um Schrittweite*10 vermindern
              lcd.clear();                        // LCD löschen
            }
        break;                                    // aussteigen, dieses Menü beginnt dann von vorne

      case 1:                                     // Menü 2 RX Offset
        lcd.setCursor(0, 0);                      // 1. Zeichen, 1. Zeile
        lcd.print("RX Oscillator[Hz/10]");        // schreiben
        lcd.setCursor(0, 1);                      // 1. Zeichen, 2. Zeile
        lcd.print(RXosz);                         // schreiben
            if (up == LOW)                        // wenn up Taste betätigt
            {
              delay(200);                         // Verzögerung
              RXosz=RXosz+sw;                     // Wert um Schrittweite erhöhen
              lcd.clear();                        // LCD löschen
            }
            if (down == LOW)                      // wenn down Taste betätigt
            {
              delay(200);                         // Verzögerung
              RXosz=RXosz-sw;                     // Wert um Schrittweite vermindern
              lcd.clear();                        // LCD löschen
            }
        break;                                    // aussteigen, dieses Menü beginnt dann von vorne
        
      case 2:                                     // Menü 2 Split Offset
        lcd.setCursor(0, 0);                      // 1. Zeichen, 1. Zeile
        lcd.print("Split Offset [Hz]");           // schreiben
        lcd.setCursor(0, 1);                      // 1. Zeichen, 2. Zeile
        lcd.print(Splitoffset*10);                // schreiben
            if (up == LOW)                        // wenn up Taste betätigt
            {
              delay(200);                         // Verzögerung
              Splitoffset=Splitoffset+sw;         // Wert um Schrittweite erhöhen
              lcd.clear();                        // LCD löschen
            }
            if (down == LOW)                      // wenn down Taste betätigt
            {
              delay(200);                         // Verzögerung
              Splitoffset=Splitoffset-sw;         // Wert um Schrittweite vermindern
              lcd.clear();                        // LCD löschen
            }
        break;                                    // aussteigen, dieses Menü beginnt dann von vorne

      case 3:                                     // Menü 3 Step Size
        lcd.setCursor(0, 0);                      // 1. Zeichen, 1. Zeile
        lcd.print("Step size");                   // schreiben
            if (up == LOW)                        // wenn up Taste betätigt
            {
              delay(200);                         // Verzögerung
              sw=sw*10;                           // Wert mit 10 multiplizieren
              lcd.clear();                        // LCD löschen
            }
            if (down == LOW)                      // wenn down Taste betätigt
            {
              delay(200);                         // Verzögerung
              sw=sw/10;                           // Wert durch 10 dividieren
              lcd.clear();                        // LCD löschen
            }
            if (sw*10 > 100000000) {sw=1;}        // max Begrenzung auf 100M
            if (sw < 1) {sw=1;}                   // min Begrenzung auf 1
            if (sw*10 < 1000){                    // Beschriftung und Umrechnung in Hz
              lcd.setCursor(0, 1);                // 1. Zeichen, 2. Zeile
              lcd.print(sw*10);                   // schreiben   
              lcd.setCursor(5, 1);                // 5. Zeichen, 2. Zeile
              lcd.print("Hz");                    // schreiben
            }
            if (sw*10 > 999 && sw*10 < 1000000){  // Beschriftung und Umrechnung in KHz
              lcd.setCursor(0, 1);                // 1. Zeichen, 2. Zeile
              lcd.print(sw*10/1000);              // schreiben
              lcd.setCursor(5, 1);                // 5. Zeichen, 2. Zeile
              lcd.print("KHz");                   // schreiben
            }
            if (sw*10 > 999999 && sw*10 < 1000000000){ // Beschriftung und Umrechnung in MHz
              lcd.setCursor(0, 1);                // 1. Zeichen, 2. Zeile
              lcd.print(sw*10/1000000);           // schreiben
              lcd.setCursor(5, 1);                // 5. Zeichen, 2. Zeile
              lcd.print("MHz");                   // schreiben
            }
        break;                                    // aussteigen, dieses Menü beginnt dann von vorne
        
      case 4:                                     // Menü 4, hier werden die Werte gespeichert und der arduino beginnt loop neu auszuführen
        lcd.setCursor(0, 0);                      // 1. Zeichen, 1. Zeile
        lcd.print("store Offsets?");              // schreiben
        lcd.setCursor(0, 1);                      // 1. Zeichen, 2. Zeile
        lcd.print("down or menu= No");            // schreiben
        lcd.setCursor(18, 2);                     // 1. Zeichen, 3. Zeile
        lcd.print("up= Yes");                     // schreiben
            if (up == LOW)                        // wenn up Taste betätigt
            {
              delay(200);                         // Verzögerung
              EEPROM.put(0, TXosz);               // Wert ins eeprom schreiben (Adresse 0)
              delay(200);                         // Verzögerung
              EEPROM.put(10, RXosz);              // Wert ins eeprom schreiben (Adresse 10)
              delay(200);                         // Verzögerung
              lcd.setCursor(0, 1);                // 1. Zeichen, 1. Zeile
              lcd.clear();                        // LCD löschen
              lcd.print("Offsets stored");        // schreiben
              delay(2000);                        // Verzögerung
              lcd.clear();                        // LCD löschen
              delay(200);                         // Verzögerung
              menucounter = 5;                    // Menü Zähler auf 5 setzen
              menuPushCounter = 0;                // Menütastenzähler auf 0 setzen
              break;                              // aussteigen, zurück zu loop
            }
            if (down == LOW)                      // wenn down Taste betätigt
            {
              lcd.clear();                        // LCD löschen
              delay(200);                         // Verzögerung
              menucounter = 5;                    // Menü Zähler auf 5 setzen
              menuPushCounter = 0;                // Menütastenzähler auf 0 setzen
              break;                              // aussteigen, zurück zu loop
            }
    }
  }
}
